var scaling = "fit";
var width = 860;
var height = 550;
//var color = "#cee1ff";
var color = "#b0c9f4";
var outerColor = "#cecece";

var zimAudioSpriteData = {
    src: "audioSpriteLorry.mp3",
    audioSprite: [
        ['driveOff', 2, 10.5],
        ['driveOn1', 12, 21],
        ['driveOn2', 22, 31],
        ["ding", 31.7, 32],
        ["stirTea", 32.4, 35.5]
    ]
}

var assets = [{
        font: "assets/childFriendly",
        src: "childFriendly.ttf"
    }, zimAudioSpriteData, "backLink.png", "contract.png", "copyright.png", "expand.png",
    "flatbed.png", "rearFlatbed.png", "wheel.png", "wheelArch.png", "yellowCab.png", "yellowChassis.png", "oleo.png", "clampL.png",
    "clampR.png", "wallSection.png", "greenCab.png", "redCab.png", "redChassis.png", "blueCab.png", "pinkCab.png", "whiteCab.png",
    "chalk1.png", "chalk2.png", "chalk3.png", "chalk4.png", "chalk5.png", "chalk6.png", "chalk7.png", "chalk8.png", "chalk9.png", "chalk10.png",
    "chalk11.png", "chalk12.png", "head1.png", "head2.png", "head3.png", "head4.png", "head5.png", "head6.png", "tick.png", "menuScrnlorry.png",
    "goBtn.png", "brew.png"
];
var progress = new ProgressBar({
    barType: "rectangle",
    foregroundColor: "#f3dc7f",
    backgroundColor: "#18254d",
    borderWidth: 5
});
var path = "assets/";

var frame = new Frame("holder", width, height, color, outerColor, assets, path, progress);
var frameBig = new zim.Frame("fit", width, height, color);
frameBig.on("ready", function() {
    frameBig.canvas.style.display = "none";
});
frame.on("ready", function() {

    zim.Ticker.update = true;
    var stage = frame.stage;
    var stageW = frame.width;
    var stageH = frame.height;

    var shell = new zim.Container(stageW, stageH)
        .addTo(stage);

    var bgContainer = new zim.Container();
    bgContainer.name = "bgContainer";
    shell.addChild(bgContainer);

    var lorryContainer = new zim.Container();
    lorryContainer.name = "lorryContainer";
    shell.addChild(lorryContainer);

    var liftContainer = new zim.Container();
    liftContainer.name = "liftContainer";
    shell.addChild(liftContainer);
    liftContainer.y = -35;

    var answerContainer = new zim.Container();
    answerContainer.name = "answerContainer";
    shell.addChild(answerContainer);

    var driverContainer = new zim.Container();
    driverContainer.name = "driverContainer";
    shell.addChild(driverContainer);

    var fingerContainer = new zim.Container();
    fingerContainer.name = "fingerContainer";
    shell.addChild(fingerContainer);

    var brewContainer = new zim.Container();
    brewContainer.name = "brewContainer";
    shell.addChild(brewContainer);
    brewContainer.visible = false;

    var menuContainer = new zim.Container();
    menuContainer.name = "menuContainer";
    shell.addChild(menuContainer);




    var backLink = frame.asset("backLink.png");
    backLink.scaleX = backLink.scaleY = .3;
    backLink.y = 5;
    backLink.x = 5;
    shell.addChild(backLink);

    var copyright = frame.asset("copyright.png");
    copyright.reg(copyright.width / 2, copyright.height / 2);
    copyright.scaleX = copyright.scaleY = .65;
    copyright.y = 275;
    copyright.x = 852;
    copyright.rotation = 270;
    copyright.alpha = .9;
    shell.addChild(copyright);


    backLink.on("click", function() {
        zgo("../index.html");
    });



    var smallFrame = true; // track which frame is in use
    var expand = frame.asset("expand.png");
    expand.scaleX = expand.scaleY = .75;
    expand.y = 10;
    expand.x = 760;
    expand.alpha = .75;
    shell.addChild(expand);

    var contract = frame.asset("contract.png");
    contract.scaleX = contract.scaleY = .75;
    contract.y = 10;
    contract.x = 760;
    contract.alpha = .75;
    shell.addChild(contract);
    contract.visible = false;
    frameBig.allowDefault = true;


    contract.on("click", function() {
        stage = frame.stage;
        zet("article").css("display", "block");
        frameBig.canvas.style.display = "none";
        contract.visible = false;
        expand.visible = true;
        frameBig.allowDefault = true;
        frame.allowDefault = true;
        //frame.fullscreen(!frame.isFullscreen);
        smallFrame = true;
        shell.addTo(stage);
        stage.update();
    });

    expand.on("click", function() {

        if (shell.stage == frame.stage) {
            stage = frameBig.stage;
            zet("article").css("display", "none");
            frameBig.canvas.style.display = "block";
            contract.visible = true;
            expand.visible = false;
            frameBig.allowDefault = false;
            frame.allowDefault = false;
            //frame.fullscreen();
        }
        smallFrame = false;
        shell.addTo(stage);
        //restartAnimations();
        stage.update();
    });



    var correctAns = 45;
    var currentAns = 0;
    var scaleLorry = .45;
    var currentMathsArray = [];
    var currentProduct = 0;
    var flatBedLength = 0;
    var currentLorry;
    var brownBoxArray = [];
    var boxColours = ["#9b8d6f", "#9e8456", "#b2a080"];
    var uiArray = [];
    var currentDriver;
    var numcorrect = 0;
    var divisionFlag = false;
    var divisionLabel;
    var numToGetMastery = 6;
    var chosenTables = [];
    // var debugLabel1=new Label({
    //    text:"",
    //    size:17,
    //    font:"tahoma",
    // 	 align:"left"
    // });
    // debugLabel1.loc(25,405,bgContainer);
    // var debugLabel2=new Label({
    //    text:"",
    //    size:17,
    //    font:"tahoma",
    // 	 align:"left"
    // });
    // debugLabel2.loc(25,425,bgContainer);

    var menuScrnlorry = asset("menuScrnlorry.png");
    menuScrnlorry.loc(0, 0, menuContainer);


    var brew = asset("brew.png");
    brew.reg(brew.width / 2, brew.height / 2);
    brew.loc(430, 255, brewContainer);


    var goBtn = asset("goBtn.png");
    goBtn.reg(goBtn.width / 2, goBtn.height / 2);
    goBtn.sca(.6);
    goBtn.loc(725, 175, menuContainer);
    goBtn.cursor = "pointer";
    goBtn.visible = false;

    var twoCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    twoCB.loc(82, 142, menuContainer);

    var threeCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    threeCB.loc(172, 142, menuContainer);

    var fourCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    fourCB.loc(262, 142, menuContainer);

    var fiveCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    fiveCB.loc(352, 142, menuContainer);

    var sixCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    sixCB.loc(442, 142, menuContainer);

    var sevenCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    sevenCB.loc(532, 142, menuContainer);


    var eightCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    eightCB.loc(82, 200, menuContainer);

    var nineCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    nineCB.loc(172, 200, menuContainer);

    var tenCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    tenCB.loc(261, 200, menuContainer);

    var elevenCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    elevenCB.loc(352, 200, menuContainer);

    var twelveCB = new CheckBox({
        size: 30,
        corner: 2,
        borderColor: "#305b99",
        label: ""
    });
    twelveCB.loc(442, 200, menuContainer);

    var checkBoxArray = [twoCB, threeCB, fourCB, fiveCB, sixCB, sevenCB, eightCB, nineCB, tenCB, elevenCB, twelveCB];

    for (var checkLoop = 0; checkLoop < checkBoxArray.length; checkLoop++) {
        checkBoxArray[checkLoop].myNum = checkLoop + 2;
        checkBoxArray[checkLoop].on("change", function() {
            whichTables();
            stage.update();
        });
    };
    goBtn.on("click", function() {
        numcorrect = 0;
        divisionFlag = false;
        scoreDisplayLabel.text = numcorrect;
        nextRound();
        hideButtons();
        displayTables();
        menuContainer.visible = false;
        brewContainer.visible = false;
        stage.update();
    });
    brew.on("click", function() {
        menuContainer.visible = true;
        brewContainer.visible = false;
        scoreDisplayLabel.text = numcorrect;
        stage.update();
    });



    var greenSizeLabel = new Label({
        text: "",
        size: 55,
        font: "childFriendly",
        align: "center",
        color: "#449b32"
    });
    greenSizeLabel.mouseEnabled = false;
    greenSizeLabel.loc(0, 0, answerContainer);
    answerContainer.visible = false;

    var tick = asset("tick.png");
    tick.reg(tick.width / 2, tick.height / 2);
    tick.sca(.6);
    tick.loc(115, 20, bgContainer);

    var versionLabel = new Label({
        text: "v1.6",
        size: 6,
        font: "arial",
        align: "left",
        color: "#2b5a9e"
    });
    versionLabel.mouseEnabled = false;
    versionLabel.loc(5, 45, bgContainer);

    var scoreDisplayLabel = new Label({
        text: "0",
        size: 25,
        font: "childFriendly",
        align: "left",
        color: "#2b5a9e"
    });
    scoreDisplayLabel.mouseEnabled = false;
    scoreDisplayLabel.loc(130, 13, bgContainer);
    //answerContainer.visible=false;

    var timesTablesInUseLabel = new Label({
        text: "",
        size: 20,
        font: "childFriendly",
        align: "left",
        color: "#2b5a9e",
        corner: 5,
        backgroundColor: "rgba(255,255,255,.65)",
        paddingVertical: 5,
        shiftVertical: 3
    });
    timesTablesInUseLabel.mouseEnabled = false;
    timesTablesInUseLabel.loc(245, 13, bgContainer);

    var flatbed = asset("flatbed.png");
    flatbed.reg(0, 0);

    var rearFlatbed = asset("rearFlatbed.png");
    rearFlatbed.cache({
        margin: 10,
        scale: 1
    });
    rearFlatbed.reg(0, 0);

    var wheel = asset("wheel.png");
    wheel.cache({
        margin: 10,
        scale: 1
    });
    wheel.reg(wheel.width / 2, wheel.height / 2);

    var wheelArch = asset("wheelArch.png");
    wheelArch.reg(wheelArch.width / 2, 0);

    var yellowCab = asset("yellowCab.png");
    yellowCab.cache({
        margin: 10,
        scale: 1
    });
    yellowCab.reg(0, yellowCab.height);

    var greenCab = asset("greenCab.png");
    greenCab.cache({
        margin: 10,
        scale: 1
    });
    greenCab.reg(0, greenCab.height);

    var whiteCab = asset("whiteCab.png");
    whiteCab.cache({
        margin: 10,
        scale: 1
    });
    whiteCab.reg(0, whiteCab.height);

    var redCab = asset("redCab.png");
    redCab.cache({
        margin: 10,
        scale: 1
    });
    redCab.reg(0, redCab.height);

    var blueCab = asset("blueCab.png");
    blueCab.cache({
        margin: 10,
        scale: 1
    });
    blueCab.reg(0, blueCab.height);

    var pinkCab = asset("pinkCab.png");
    pinkCab.cache({
        margin: 10,
        scale: 1
    });
    pinkCab.reg(0, pinkCab.height);

    var frontChassis = asset("yellowChassis.png");
    frontChassis.cache({
        margin: 10,
        scale: 1
    });
    frontChassis.reg(0, 0);

    var redChassis = asset("redChassis.png");
    redChassis.cache({
        margin: 10,
        scale: 1
    });
    redChassis.reg(0, 0);

    var lorryTypes = [yellowCab, greenCab, blueCab, whiteCab, redCab, pinkCab];

    var oleo = asset("oleo.png");
    oleo.sca(.5);
    oleo.loc(0, 75, liftContainer);

    var clampL = asset("clampL.png");
    clampL.reg(clampL.width, 0);
    clampL.sca(.45);
    clampL.loc(75, 65, liftContainer);

    var clampR = asset("clampR.png");
    clampR.reg(0, 0);
    clampR.sca(.45);
    clampR.loc(725, 65, liftContainer);

    // var nextRoundRect=new Rectangle({width:45, height:15, color:"blue", corner:5});
    // nextRoundRect.loc(365,395,bgContainer);

    var wallSection = asset("wallSection.png");
    wallSection.sca(.9);
    for (var wallNum = 0; wallNum < 6; wallNum++) {
        var tempWall = wallSection.clone();
        tempWall.alpha = .2;
        tempWall.loc(wallNum * (wallSection.width * .95), 0, bgContainer);
    };

    var chalkText = ["chalk1", "chalk2", "chalk3", "chalk4", "chalk5", "chalk6", "chalk7", "chalk8", "chalk9", "chalk10", "chalk11", "chalk12"];
    var chalkWritArray = [];
    for (var chalkNum = 0; chalkNum < chalkText.length; chalkNum++) {
        var tempChalk = asset(chalkText[chalkNum] + ".png");
        tempChalk.reg(tempChalk.width / 2, tempChalk.height / 2);
        chalkWritArray.push(tempChalk);
    };

    var headAssets = ["head1", "head2", "head3", "head4", "head6", "head5"];
    var driverArray = [];
    for (var driverNum = 0; driverNum < headAssets.length; driverNum++) {
        var tempDriver = asset(headAssets[driverNum] + ".png");
        tempDriver.reg(tempChalk.width / 2, tempChalk.height / 2);
        tempDriver.sca(.35);
        driverArray.push(tempDriver);
        tempDriver.loc(880, 265, driverContainer);
    };

    var fingBut = new Rectangle({
        width: 65,
        height: 175,
        color: "rgba(124,239,103,.75)",
        borderColor: "#3fa027",
        borderWidth: 2,
        corner: 30
    });
    for (var g = 0; g < 10; g++) {
        var tempFingBut = fingBut.clone();
        tempFingBut.myValue = g;
        var fingLabel = new Label({
            text: tempFingBut.myValue,
            size: 45,
            font: "childFriendly",
            align: "center",
            color: "#3fa027"
        });
        fingLabel.mouseEnabled = false;
        fingLabel.loc(32, 35, tempFingBut);
        tempFingBut.loc((g * 70) + 80, 425, fingerContainer);
        tempFingBut.cursor = "pointer";
        tempFingBut.on("mousedown", function(e) {
            asset("ding").play();
            e.currentTarget.y = 445;
            stage.update();
        });
        tempFingBut.on("pressup", function(e) {
            e.currentTarget.y = 425;
            if (currentAns < 200) {
                currentAns *= 10;
                currentAns += e.currentTarget.myValue;
                if (divisionFlag == false) {
                    greenSizeLabel.text = currentAns;
                } else {
                    divisionLabel.text = currentAns;
                    divisionLabel.parent.updateCache();
                    //divisionLabel.cache({width:divisionLabel.width*2,height:divisionLabel.height*2,scale:2});
                }

            }
            stage.update();
        });
        uiArray.push(tempFingBut);
    };
    var deleteBut = new Rectangle({
        width: 65,
        height: 175,
        color: "rgba(247,15,15,.75)",
        borderColor: "#a02828",
        borderWidth: 2,
        corner: 30
    });
    var delLabel = new Label({
        text: "X",
        size: 25,
        font: "childFriendly",
        align: "center",
        color: "#ffffff"
    });
    delLabel.loc(32, 35, deleteBut);
    deleteBut.loc(8, 425, fingerContainer);
    deleteBut.cursor = "pointer";
    uiArray.push(deleteBut);
    deleteBut.on("mousedown", function(e) {
        asset("ding").play();
        e.currentTarget.y = 445;
        stage.update();
    });
    deleteBut.on("pressup", function(e) {

        e.currentTarget.y = 425;
        currentAns = 0;
        //greenSizeLabel.text=currentAns;
        if (divisionFlag == true) {
            divisionLabel.text = "?";
            divisionLabel.parent.updateCache();
        } else {
            greenSizeLabel.text = currentAns;
        }
        stage.update();
    });

    var enterBut = new Rectangle({
        width: 65,
        height: 175,
        color: "rgba(124,239,103,1)",
        borderColor: "#3fa027",
        borderWidth: 2,
        corner: 30
    });
    var enterLabel = new Label({
        text: "go",
        size: 35,
        font: "childFriendly",
        align: "center",
        color: "#3fa027"
    });
    enterLabel.loc(32, 35, enterBut);
    enterBut.loc(780, 465, fingerContainer);
    enterBut.cursor = "pointer";
    uiArray.push(enterBut);
    enterBut.on("mousedown", function(e) {
        asset("ding").play();
        e.currentTarget.y = 445;
        stage.update();
    });
    enterBut.on("pressup", function(e) {
        e.currentTarget.y = 425;
        if (currentAns == correctAns) {
            liftGoods();
            hideButtons();
            sendOffDriver();
            numcorrect++;
            scoreDisplayLabel.text = numcorrect;
            if (divisionFlag == true) {
                divisionLabel.text = "";
                divisionLabel.parent.updateCache();
            }
        } else {
            currentAns = 0;
            if (divisionFlag == true) {
                divisionLabel.text = "?";
                divisionLabel.parent.updateCache();
            } else {
                greenSizeLabel.text = currentAns;
            }
        };
        stage.update();
    });

    function whichTables() {
        chosenTables = [];
        for (var checkLoop = 0; checkLoop < checkBoxArray.length; checkLoop++) {
            if (checkBoxArray[checkLoop].checked == true) {
                chosenTables.push(checkLoop + 2);
            };
        };
        if (chosenTables.length > 2) {
            goBtn.visible = true;
        } else {
            goBtn.visible = false;
        }
    }

    function resetLift() {
        liftContainer.animate({
            props: {
                y: -35
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
        clampL.animate({
            props: {
                x: 45
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
        clampR.animate({
            props: {
                x: 815
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
    };

    function removeGreenBox() {
        answerContainer.visible = false;
        for (var i = bgContainer.numChildren - 1; i > -1; i--) {
            var tempObj = bgContainer.getChildAt(i);
            if (tempObj.myType == "greenBox") {
                bgContainer.removeChild(tempObj);
                tempObj = null;
            }
        }
    }

    function liftGoods() {
        removeGreenBox();
        liftContainer.animate({
            props: {
                y: 125
            },
            time: 1,
            loop: false,
            ease: "sineOut",
            call: moveBoxesToCrane
        });
    };

    function liftCrane() {
        liftContainer.animate({
            props: {
                y: -245
            },
            time: 2,
            loop: false,
            ease: "sineInOut",
            call: driveOffLorry
        });
    };

    function raiseSuspension() {
        currentLorry.myCab.animate({
            props: {
                y: currentLorry.myCab.y - 8
            },
            time: 1,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myFlatbed.animate({
            props: {
                y: currentLorry.myFlatbed.y - 8
            },
            time: .75,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myRear.animate({
            props: {
                y: currentLorry.myRear.y - 8
            },
            time: .75,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myFrontChassis.animate({
            props: {
                y: currentLorry.myFrontChassis.y - 8
            },
            time: .75,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myWheelArches[0].animate({
            props: {
                y: currentLorry.myWheelArches[0].y - 8
            },
            time: .75,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myWheelArches[1].animate({
            props: {
                y: currentLorry.myWheelArches[1].y - 8
            },
            time: .75,
            loop: false,
            ease: "sineIn"
        });
        if (currentLorry.myWheelArches[2]) {
            currentLorry.myWheelArches[2].animate({
                props: {
                    y: currentLorry.myWheelArches[2].y - 8
                },
                time: .75,
                loop: false,
                ease: "sineIn"
            });
        }

    };

    function moveBoxesToCrane() {

        var farthestX = brownBoxArray[brownBoxArray.length - 1].x;
        for (var i = 0; i < brownBoxArray.length; i++) {
            var tempObj = brownBoxArray[i];
            tempObj.x = farthestX + 725 + (((brownBoxArray.length - 1) - i) * tempObj.width);
            tempObj.y = tempObj.y + 80;
            tempObj.loc(tempObj.x, tempObj.y, liftContainer);
        };
        liftCrane();
        raiseSuspension();
    };

    function replaceLorry() {
        lorryContainer.disposeAllChildren();
        resetLift();
        nextRound();
    }

    function driveOffLorry() {
        asset("driveOff").play();
        for (var i = brownBoxArray.length; i > -1; i--) {
            var tempObj = brownBoxArray[i];
            liftContainer.removeChild(tempObj);
            tempObj = null;
        };
        brownBoxArray = [];
        currentLorry.animate({
            props: {
                x: 1750
            },
            time: 7,
            loop: false,
            ease: "sineIn",
            call: replaceLorry
        });
        currentLorry.myWheels[0].animate({
            props: {
                rotation: currentLorry.myWheels[0].rotation + 1900
            },
            time: 7,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myWheels[1].animate({
            props: {
                rotation: currentLorry.myWheels[1].rotation + 1900
            },
            time: 7,
            loop: false,
            ease: "sineIn"
        });
        currentLorry.myWheels[2].animate({
            props: {
                rotation: currentLorry.myWheels[2].rotation + 1900
            },
            time: 7,
            loop: false,
            ease: "sineIn"
        });
    };

    function adjustLift(leftPos) {
        clampR.animate({
            props: {
                x: 710
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
        clampL.animate({
            props: {
                x: leftPos
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
        liftContainer.animate({
            props: {
                y: 15
            },
            time: 1,
            loop: false,
            ease: "sineOut",
            call: makeGreenBar,
            params: [leftPos, 710]
        });
    };

    function setBedLength(thisProduct) {
        var tempUnit = 0;
        if (thisProduct > 50) {
            tempUnit = zim.rand(2, 10) / 7;
        } else if (thisProduct > 30) {
            tempUnit = zim.rand(8, 30) / 20;
        } else {
            tempUnit = zim.rand(15, 30) / 20;
        };
        return tempUnit.toFixed(2);
    };


    function newLorry(loadSize) {
        var lorryStyleNum = zim.rand(0, lorryTypes.length - 1);
        var tempContainer = new zim.Container();
        tempContainer.myDriverNum = lorryStyleNum;

        var tempCab = lorryTypes[lorryStyleNum].clone();
        if (lorryStyleNum < 4) {
            var tempfrontChassis = frontChassis.clone();
            tempCab.reg(10, -10);
        } else {
            var tempfrontChassis = redChassis.clone();
            tempCab.reg(35, -35);
        }
        var tempRear = rearFlatbed.clone();
        var tempFlatbed = flatbed.clone();
        if (lorryStyleNum < 4) {
            var tempFWheelArch = wheelArch.clone();
            tempFWheelArch.reg(tempFWheelArch.width / 2, 0);
            tempFWheelArch.sca(scaleLorry);
        }
        var tempRRWheelArch = wheelArch.clone();
        var tempRFWheelArch = wheelArch.clone();
        var tempWheelF = wheel.clone();
        var tempWheelMid = wheel.clone();
        var tempWheelRear = wheel.clone();

        tempfrontChassis.reg(tempfrontChassis.width / 2, 0);

        tempRear.reg(tempRear.width, 0);
        tempFlatbed.reg(0, 0);
        tempWheelF.reg((tempWheelF.width / 2) - 2, (tempWheelF.height / 2) + 4);
        tempWheelMid.reg((tempWheelMid.width / 2) - 2, (tempWheelMid.height / 2) + 4);
        tempWheelRear.reg((tempWheelRear.width / 2) - 2, (tempWheelRear.height / 2) + 4);
        tempRRWheelArch.reg(tempRFWheelArch.width / 2, 0);
        tempRFWheelArch.reg(tempRFWheelArch.width / 2, 0);

        tempfrontChassis.sca(scaleLorry);
        tempCab.sca(scaleLorry);
        tempRear.sca(scaleLorry);
        tempFlatbed.sca(scaleLorry);
        tempWheelF.sca(scaleLorry);
        tempWheelMid.sca(scaleLorry);
        tempWheelRear.sca(scaleLorry);
        tempRRWheelArch.sca(scaleLorry);
        tempRFWheelArch.sca(scaleLorry);

        tempWheelF.rotation = zim.rand(0, 359);
        tempWheelMid.rotation = zim.rand(0, 359);
        tempWheelRear.rotation = zim.rand(0, 359);
        flatBedLength = setBedLength(loadSize);
        //debugLabel2.text=flatBedLength;
        //var flatBedLength=(loadSize/40);
        tempFlatbed.scaleX = (flatBedLength / 2) + .1;
        tempFlatbed.loc(0, tempFlatbed.height * 4.66, tempContainer);
        tempRear.loc((flatBedLength * 325) * -1, tempRear.height * 2.265, tempContainer);
        tempFlatbed.x = tempRear.x - 2;

        tempCab.loc(0, 0, tempContainer);
        if (lorryStyleNum < 4) {
            tempfrontChassis.loc(0, 0, tempContainer);
            tempWheelF.loc(tempCab.x + ((tempCab.width / 9) * 2) - 2, tempWheelF.height * 2.8, tempContainer); // x linked to cab
        } else {
            tempfrontChassis.loc(0, 0, tempContainer);
            tempWheelF.loc(tempCab.x + ((tempCab.width / 2) * 1.1) - 2, tempWheelF.height * 2.8, tempContainer); // x linked to cab
        }
        tempWheelMid.loc(tempRear.x - (tempWheelMid.width / 3) - 2, tempWheelF.height * 2.8, tempContainer); // x linked to rearFlatBed
        tempWheelRear.loc(tempRear.x - (tempWheelRear.width * 1.5), tempWheelRear.height * 2.8, tempContainer); // x linked to rearFlatBed
        if (lorryStyleNum < 4) {
            tempFWheelArch.loc(tempCab.x + ((tempCab.width / 10) * 2), tempCab.height + 5, tempContainer);
        }
        tempRRWheelArch.loc(tempRear.x - (tempRear.width * .65), (tempRRWheelArch.height * 4) - (tempRRWheelArch.height / 10), tempContainer);
        tempRFWheelArch.loc(tempRear.x - (tempRFWheelArch.width / 3), (tempRRWheelArch.height * 4) - (tempRRWheelArch.height / 10), tempContainer);
        tempContainer.myCab = tempCab;
        tempContainer.myWheels = [tempWheelF, tempWheelMid, tempWheelRear];
        tempContainer.myFlatbed = tempFlatbed;
        tempContainer.myRear = tempRear;
        tempContainer.myFrontChassis = tempfrontChassis;
        if (lorryStyleNum < 4) {
            tempContainer.myWheelArches = [tempFWheelArch, tempRRWheelArch, tempRFWheelArch];
        } else {
            tempContainer.myWheelArches = [tempRRWheelArch, tempRFWheelArch];
        };
        tempContainer.addChild(tempCab);
        var shadowLength = (tempWheelRear.x * -1) - (tempWheelF.x * -1) + 75;
        var lorryShadow = new Rectangle({
            width: shadowLength,
            height: 10,
            color: "rgba(0,0,0,.2)",
            borderColor: "rgba(0,0,0,.45)",
            borderWidth: 0,
            corner: 5
        });
        lorryShadow.loc(tempRear.x - (tempRear.width - 35), 205, tempContainer, 0);
        // tempWheelF.cache({width:tempWheelF.width*2,height:tempWheelF.height*2,scale:2});
        // tempWheelMid.cache({width:tempWheelMid.width*2,height:tempWheelMid.height*2,scale:2});
        // tempWheelRear.cache({width:tempWheelRear.width*2,height:tempWheelRear.height*2,scale:2});
        // tempWheelF.cache({width:tempWheelF.width,height:tempWheelF.height,scale:2});
        // tempWheelMid.cache({width:tempWheelMid.width,height:tempWheelMid.height,scale:2});
        // tempWheelRear.cache({width:tempWheelRear.width,height:tempWheelRear.height,scale:2});
        tempWheelF.animate({
            props: {
                rotation: tempWheelF.rotation + 1900
            },
            time: 5,
            loop: false,
            ease: "sineOut"
        });
        tempWheelMid.animate({
            props: {
                rotation: tempWheelMid.rotation + 1900
            },
            time: 5,
            loop: false,
            ease: "sineOut"
        });
        tempWheelRear.animate({
            props: {
                rotation: tempWheelRear.rotation + 1900
            },
            time: 5,
            loop: false,
            ease: "sineOut"
        });

        return tempContainer;
    };

    function bounceCab(thisLorry) {
        thisLorry.myCab.animate({
            props: {
                rotation: thisLorry.myCab.rotation + .25,
                y: thisLorry.myCab.y + 1
            },
            time: .5,
            loop: true,
            rewind: true,
            ease: "sineIn",
            wait: 4.5,
            loopCount: 2
        });
    };

    function nextProblem(multiplicandArray) {
        var tempNum = multiplicandArray[zim.rand(0, multiplicandArray.length - 1)];
        var tempArray = [zim.rand(2, 12), tempNum];
        return tempArray;
    };

    function makeBoxes(thisLorry, bedLength, numsArray) {
        var boxWidth = Math.round((bedLength + 125) / numsArray[0]);
        brownBoxArray = [];
        for (var i = 0; i < numsArray[0]; i++) {
            var tempBox = new Rectangle({
                width: boxWidth,
                height: 100,
                color: Pick.choose(boxColours),
                borderColor: "#4c4332",
                borderWidth: 2,
                corner: [5, 5, 5, 5]
            });
            tempBox.loc((((i + 1) * boxWidth) * -1) - 15, 40, thisLorry);
            tempBox.myType = "brownBox";
            tempBox.cache({
                margin: 10,
                scale: 2
            });
            brownBoxArray.push(tempBox);
        };
        if (divisionFlag == false) {
            var tempChalkWrit = chalkWritArray[numsArray[1] - 1].clone();
            tempChalkWrit.reg(tempChalkWrit.width / 2, tempChalkWrit.height / 2);
            if (boxWidth < 45) {
                var writeScale = .4;
            } else {
                var writeScale = .65;
            }
            tempChalkWrit.sca(writeScale);
            tempChalkWrit.loc(tempBox.width / 2, tempBox.height / 2, tempBox);
            tempBox.updateCache();
        } else {
            // writing ? on the box
            var questionBoxLabel = new Label({
                text: "?",
                size: 40,
                font: "childFriendly",
                align: "center",
                color: "#ffffff"
            });
            divisionLabel = questionBoxLabel;
            questionBoxLabel.loc(tempBox.width / 2, (tempBox.height / 5) * 2, tempBox);
            tempBox.updateCache();
        }

        return tempBox.x;
    };

    function makeGreenBar(posArray) {
        var tempWidth = posArray[1] - posArray[0];
        var tempBox = new Rectangle({
            width: tempWidth,
            height: 100,
            color: "rgba(124,239,103,.75)",
            borderColor: "#2cff00",
            borderWidth: 2,
            corner: 2
        });
        tempBox.loc(posArray[0], 140, bgContainer);
        tempBox.myType = "greenBox";
        answerContainer.visible = true;
        greenSizeLabel.x = tempBox.x + (tempWidth / 2);
        greenSizeLabel.y = 170;
        if (divisionFlag == false) {
            greenSizeLabel.text = "?";
        } else {
            greenSizeLabel.text = currentProduct;
        }

        bringOnButtons();
        bringOnDriver();
    };

    function bringOnDriver() {
        var whichDriver = currentLorry.myDriverNum;
        for (var i = 0; i < driverArray.length; i++) {
            driverArray[i].x = 880;
        }
        currentDriver = driverArray[whichDriver];
        driverArray[whichDriver].animate({
            props: {
                x: 725
            },
            time: 1,
            loop: false,
            ease: "sineOut"
        });
    };

    function sendOffDriver() {
        currentDriver.animate({
            props: {
                x: 880
            },
            time: .5,
            loop: false,
            ease: "sineOut"
        });
    }

    function nextRound() {
        if (numcorrect < 20) {
            currentAns = 0;
            greenSizeLabel.text = "?";
            divisionFlag = false;
            if (numcorrect > numToGetMastery) {
                var randDiv = zim.rand(0, 10);
                if (randDiv < 5) {
                    divisionFlag = true;
                }
            };
            currentMathsArray = nextProblem(chosenTables);
            currentProduct = currentMathsArray[0] * currentMathsArray[1];
            correctAns = currentProduct;
            var tempLorry = newLorry(currentProduct);
            //debugLabel1.text=currentMathsArray[0]+" x "+currentMathsArray[1]+" = "+currentProduct;
            var lastX = makeBoxes(tempLorry, (flatBedLength * 325), currentMathsArray);
            if (divisionFlag == true) {
                correctAns = currentMathsArray[1];
            };
            tempLorry.loc(-200, 205, lorryContainer);
            currentLorry = tempLorry;
            bounceCab(tempLorry);
            var randSnd = zim.rand(0, 10);
            if (randSnd < 5) {
                asset("driveOn1").play();
            } else {
                asset("driveOn2").play();
            }

            tempLorry.animate({
                props: {
                    x: 725
                },
                time: 5,
                loop: false,
                ease: "sineOut",
                call: adjustLift,
                params: lastX + 725
            });
        } else {
            asset("stirTea").play();
            brewContainer.visible = true;
            numcorrect = 0;
        }
    };

    function hideButtons() {
        for (var i = 0; i < uiArray.length; i++) {
            var tempObj = uiArray[i];
            tempObj.y = 605;
        };
        stage.update();
    };

    function bringOnButtons() {
        //e.currentTarget.y=465;
        fingerContainer.animate({
            props: {
                y: 425
            },
            sequence: .1,
            loop: false,
            ease: "sineOut"
        });
    };

    function displayTables() {
        timesTablesInUseLabel.text = "times tables in use:  "
        for (var i = 0; i < chosenTables.length; i++) {
            timesTablesInUseLabel.text += chosenTables[i] + "x ";
        }
    }









    //zim.Ticker.add(function(){stage.update();});


    stage.update();

}); // end of ready